# Tools

このモジュールは、Difyのエージェントアシスタントやワークフローで使用される組み込みツールを実装しています。このモジュールでは、フロントエンドのロジックを変更することなく、独自のツールを定義し表示することができます。この分離により、Difyの機能を容易に水平方向にスケールアウトできます。

## 機能紹介

エージェントとワークフロー向けに提供されるツールは、現在2つのカテゴリーに分類されています。

- `Built-in Tools`はDify内部で実装され、エージェントとワークフローで使用するためにハードコードされています。
- `Api-Based Tools`はサードパーティのAPIを利用して実装されています。これらを統合するためのコーディングは不要で、フロントエンドで
  `OpenAPI`, `Swagger`または`OpenAI-plugin`などの形式でインターフェース定義を提供するだけです。

### 組み込みツールプロバイダー

![Alt text](docs/images/index/image.png)

### APIツールプロバイダー

![Alt text](docs/images/index/image-1.png)

## ツールの統合

開発者が柔軟で強力なツールを構築できるよう、2つのガイドを提供しています。

### [クイック統合 👈🏻](./docs/ja_JP/tool_scale_out.md)

クイック統合は、Google検索ツールの例を通じて、ツール統合の基本をすばやく理解できるようにすることを目的としています。

### [高度な統合 👈🏻](./docs/ja_JP/advanced_scale_out.md)

高度な統合では、モジュールインターフェースについてより深く掘り下げ、画像生成、複数ツールの組み合わせ、異なるツール間でのパラメーター、画像、ファイルのフロー管理など、より複雑な機能の実装方法を説明します。